Scriptname LuA_Main extends Quest

;ent/ Properties / Includes
AAF:AAF_API AAF_API
GlobalVariable property LuA_Version auto
GlobalVariable property LuA_aug_cc_active auto
GlobalVariable property LuA_aug_sg_active auto
GlobalVariable property LuA_aug_ks_active auto
GlobalVariable property LuA_aug_sb_active auto
GlobalVariable property LuA_aug_gt_active auto
GlobalVariable property LuA_aug_rs_active auto
GlobalVariable property LuA_mod_se_active auto
GlobalVariable property LuA_mod_da_active auto
GlobalVariable property LuA_mod_da_rads auto
GlobalVariable property LuA_mod_da_capsperc auto
GlobalVariable property LuA_mod_da_mustrestreturn auto
GlobalVariable property LuA_mod_da_trytoanim auto
GlobalVariable property LuA_mod_da_waitforanim auto
GlobalVariable property LuA_set_adultify auto
GlobalVariable property LuA_set_animlength auto
GlobalVariable property LuA_PC_MaxAug auto
GlobalVariable property LuA_PC_CurAug auto
GlobalVariable property LuA_PC_StrAug auto
ObjectReference property LuA_marker_LastEntry auto
ObjectReference property LuA_marker_RestEntry auto
ObjectReference property LuA_marker_LimboEntry auto
Cell property LuAworldholding auto
MiscObject property Caps001 auto
Potion Property LuA_item_sperm auto
Potion property LuA_item_sg_up auto
Potion property LuA_item_cc_up auto
Potion property LuA_item_ks_up auto
Potion property LuA_item_sb_up auto
Potion property LuA_item_gt_up auto
Potion property LuA_item_rs_up auto
Potion property LuA_item_sbod_up auto
Potion property LuA_item_tbod_up auto
Potion property LuA_item_mbod_up auto
Potion property LuA_item_removeaugs auto
ActorValue property Health auto
ActorValue property Rads auto
ActorValue property ActionPoints auto
ActorValue property Charisma auto
Actor Property PlayerRef auto
Keyword Property LuA_key_aug auto
Keyword Property ObjectTypeFood auto
Keyword Property ObjectTypeWater auto
Keyword Property ObjectTypeAlcohol auto
Keyword Property ObjectTypeNukaCola auto
Keyword Property ActorTypeNPC auto
Keyword Property ActorTypeCreature auto
Faction property LuA_fac_tempally auto
;end/

;ent/ Variables / References
WorldSpace PreviousLocal
int TimerGenPoll ; Timer for the Generic Tick
int WasBleedingOut ; Player Was Bleeding Out
int AdvCheckWait ; Delay for advanced on-tick functions
int PlayerInAAF ; Use as bool/enum to check animation state
int DOMprocessing ; DOM processing toggle
int RespawnPoint ; 0=RestEntry 1=LastEntry
int AAFfound ; If AAF API was found
float aug_ks_buildup ; Build-Up Bonus XP from Killing Spree Passive
int aug_ks_notify ; Whether we should notify
Actor[] CombatActors ; Actors in combat with the player
Actor LastHitActor ; Last Actor to 'hit' the player
int DOMaaffailed ; If AAF failed 0=noinit 1=failed 2=validated
int LastHitActorTimer ; Timer to remove LastHitActor
bool KeySeductressPressed ; If the key for seductress actions has been pressed
bool ActorSeduced ; If Processing Actor Seduced
bool AugCapped ; Augment Max has been capped for the player level
int SeductionCooldown ; Cooldown timer for Seduction
float RadSleeperTime ; Time start for Rad Sleeper
float RadSleeperEnd ; Time end for Rad Sleeper
;end/

;ent/ Initiate
Function LoadAAF()
	AAF_API = Game.GetFormFromFile(0x00000F99, "AAF.esm") as AAF:AAF_API
	If !AAF_API
		AAFfound = 0
		utility.wait(0.1)
	Else
		AAFfound = 1
		RegisterForCustomEvent(AAF_API, "OnSceneInit")
		RegisterForCustomEvent(AAF_API, "OnAnimationStart")
		RegisterForCustomEvent(AAF_API, "OnAnimationChange")
		RegisterForCustomEvent(AAF_API, "OnAnimationStop")
	Endif
EndFunction
	
Event OnQuestInit()
	RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
	LoadAAF()
	ModUpdate()
EndEvent

Event Actor.OnPlayerLoadGame(actor aSender)
	; Event Registers
	RegisterForRemoteEvent(PlayerRef, "OnPlayerLoadGame")
	RegisterForPlayerSleep()
	RegisterForPlayerWait()
	RegisterForExternalEvent("OnMCMOpen", "OnMCMOpen");
    RegisterForExternalEvent("OnMCMSettingChange|LucrativeAugments", "OnMCMSettingChange")
	RegisterForHitEvent(PlayerRef) ; Hit Event with no filters
	RegisterForKey(66)
	LoadAAF()
	ModUpdate()
EndEvent

Function ModUpdate()
	;Always Run
	AugStrCalc(false)
	if LuA_mod_da_active.GetValue()
		PlayerRef.SetEssential(True)
	endIf
	StartTimer(1, TimerGenPoll) ;Start General Poll Timer
	float ModVersion = LuA_Version.GetValue()
	if ModVersion > (0.04)
		LuA_Version.SetValue(0.04)
	endIf
endFunction
;end/

; Props\Chipboard.nif
; Props\MilitaryCircuitBoard\MilitaryCircuitBoard.nif
; Props\GenericKeycard01.nif
; Props\Fuse01.nif
; Props\BoSFluxSensor\BoSFluxSensor.nif
; Props\SyringeAmmo.nif
; Props\MedX.nif
; Props\DaddyO01.nif
; Props\Stimpack01.nif

;ent/ Key Presses
Event OnKeyDown(int keyCode)
	if (keyCode == 66) ; B
		if LuA_mod_se_active.GetValue() && KeySeductressPressed != true
			KeySeductressPressed = true
			if SeductionCooldown != 0
				debug.Notification("Seduction on cooldown : "+SeductionCooldown+"s Remaining")
			elseif PlayerRef.HasKeyword(AAF_API.AAF_ActorBusy)
				debug.Notification("Already in an animation!")
			elseif PlayerRef.IsInCombat()
				debug.Notification("Can't use seduction while in combat!")
			elseif ActorSeduced == true
				debug.Notification("A target was already seduced!")
			else
				ObjectReference[] CloseTypeNPC = PlayerRef.FindAllReferencesWithKeyword(ActorTypeNPC, 80.0)
				ObjectReference[] CloseTypeCreature = PlayerRef.FindAllReferencesWithKeyword(ActorTypeCreature, 80.0)
				Actor SedActor = none
				bool escape = false
				int i = 0
				While escape != true
					Actor tempActor = CloseTypeNPC[i] as actor
					if tempActor == PlayerRef || tempActor.HasKeyword(AAF_API.AAF_ActorBusy)
						i += 1
						if i >= CloseTypeNPC.Length
							
							escape = true
						endIf
					else
						SedActor = tempActor
						escape = true
					endIf
				endWhile
				if SedActor == none
					While escape != true
						Actor tempActor = CloseTypeCreature[i] as actor
						if tempActor == PlayerRef || tempActor.HasKeyword(AAF_API.AAF_ActorBusy)
							i += 1
							if i >= CloseTypeCreature.Length
								
								escape = true
							endIf
						else
							SedActor = tempActor
							escape = true
						endIf
					endWhile
				endIf
				if SedActor != none
					if Utility.RandomInt(0, 100) < (PlayerRef.GetValue(Charisma) * 7.0 + 20.0)
						debug.Notification("Seducing a target!")
						SeductionCooldown += 600
						Actor[] AnimActors = new Actor[2]
						AnimActors[0] = PlayerRef
						AnimActors[1] = SedActor
						AAF:AAF_API:SceneSettings settings = AAF_API.GetSceneSettings()
						settings.duration = LuA_set_animlength.GetValue() as int
						settings.preventFurniture = false
						settings.usePackages = false
						settings.position = None
						settings.excludeTags = None
						;settings.locationObject = PlayerRef
						AAF_API.StartScene(AnimActors, settings)
						ActorSeduced = true
					else
						debug.Notification("Seduction Failed!")
					endIf
				else
					debug.Notification("No Seduction Target Found")
				endIf
			endIf
		endIf
	endIf
endEvent

Event OnKeyUp(int keyCode, float time)
	if (keyCode == 66) ; B
		if KeySeductressPressed == true
			KeySeductressPressed = false
		endIf
	endIf
endEvent
;end/

;ent/ Timer Functions
Event OnTimer(int aiTimerID)
	If aiTimerID == TimerGenPoll
		; Check Location
		If PlayerRef.GetWorldSpace() != PreviousLocal
			PreviousLocal = PlayerRef.GetWorldSpace()
			If PlayerRef.GetParentCell() != LuAworldholding
				LuA_marker_LastEntry.MoveTo(PlayerRef)
				RespawnPoint = 1
			endIf
		endIf
		; Get Combat Actors
		if DOMprocessing == 0 && PlayerRef.IsBleedingOut() == false
			CombatActors = PlayerRef.GetAllCombatTargets()
		endIf
		; LastHitActorTimer
		If LastHitActorTimer < 1
			LastHitActor = none
		else
			LastHitActorTimer -= 1
		endIf
		; SeductionCooldown
		if SeductionCooldown > 0
			SeductionCooldown -= 1
		endIf
		; Advanced Checks (Runs less often)
		AdvCheckWait += 1
		if AdvCheckWait > 9
			if LuA_mod_da_active.GetValue()
				PlayerRef.SetEssential(True)
			endIf
			if LuA_aug_ks_active.GetValue() > 0.0
				aug_ks_notify += 1
			endIf
			AdvCheckWait = 0
		endIf
		StartTimer(1, TimerGenPoll)
	endIf
endEvent
;end/

;ent/ Player Sleep
Event OnPlayerSleepStart(float afSleepStartTime, float afDesiredSleepEndTime, ObjectReference akBed)
	If PlayerRef.GetParentCell() != LuAworldholding
		LuA_marker_RestEntry.MoveTo(PlayerRef)
		float x = Lua_Marker_RestEntry.GetAngleX()
		float y = Lua_Marker_RestEntry.GetAngleY()
		float z = Lua_Marker_RestEntry.GetAngleZ()
		z += 180
		LuA_marker_RestEntry.SetAngle(x, y, z)
		
		RespawnPoint = 0
	endIf
	if LuA_aug_ks_active.GetValue()
		int x = Math.Floor(aug_ks_buildup)
		Game.RewardPlayerXP(x, false)
		Debug.Notification("Killing Spree Bonus Claimed : "+x)
		if LuA_aug_ks_active
			aug_ks_buildup = 0.0
		endIf
	endIf
	RadSleeperTime = afSleepStartTime
	RadSleeperEnd = afDesiredSleepEndTime
endEvent

Event OnPlayerSleepStop(bool abInterrupted, ObjectReference akBed)
	if LuA_aug_rs_active.GetValue()
		if abInterrupted == false
			PlayerRef.RestoreValue(Rads, ((RadSleeperEnd - RadSleeperTime) * ((LuA_aug_rs_active.GetValue() * 240) * LuA_PC_StrAug.GetValue())))
		endIf
	endIf
endEvent
;end/

;ent/ Player Wait
Event OnPlayerWaitStart(float afWaitStartTime, float afDesiredWaitEndTime)
	If PlayerRef.GetParentCell() != LuAworldholding
		LuA_marker_RestEntry.MoveTo(PlayerRef)
		RespawnPoint = 0
	endIf
endEvent
;end/

;ent/ Player Kill
Function PlayerKill(Actor akVictim)
	if LuA_aug_ks_active.GetValue()
		int aug_ks = LuA_aug_ks_active.GetValue() as int
		float aug_str = LuA_PC_StrAug.GetValue()
		aug_ks_buildup = ((aug_ks_buildup + (((5 + (Game.GetPlayerLevel() * 0.2)) * aug_ks) * aug_str)) + (aug_ks_buildup * 0.01))
		if aug_ks_notify >= 3
			int x = Math.Floor(aug_ks_buildup)
			Debug.Notification("Killing Spree Build-up : "+x+" XP")
			aug_ks_notify = 0
		endif
	endIf
endFunction
;end/

;ent/ OnHit (At least for those registered, like the Player)
Event OnHit(ObjectReference akTarget, ObjectReference akAggressor, Form akSource, Projectile akProjectile, bool abPowerAttack, bool abSneakAttack, bool abBashAttack, bool abHitBlocked, string apMaterial)
	if akTarget == PlayerRef ; If Player is hit
		if akAggressor as actor ; If actor hit player
			if akAggressor != none
				LastHitActor = none
			elseif akAggressor == PlayerRef
				LastHitActor = none
			else
				LastHitActor = akAggressor as actor
				LastHitActorTimer = 30
			endIf
		endIf
		RegisterForHitEvent(PlayerRef) ; Re-Register For Hit Event
	endIf
EndEvent
;end/

;ent/ Player Bleedout
Function PlayerBleedout(String bleedstate="none")
	if bleedstate == "enter"
		; DOM Calculations
		WasBleedingOut = 1
		DeathOverride()
	endIf
endFunction
;end/

;ent/ Player 'equips' or 'uses' Item
Function PlayerEquipped(Form akBaseObject, ObjectReference akReference)
	if akBaseObject.HasKeyword(LuA_key_aug)
		Game.TriggerScreenBlood(2)
		Potion UsedObject = akBaseObject as Potion
		if UsedObject == LuA_item_sg_up
			AugAdd("aug_sg")
		elseif UsedObject == LuA_item_cc_up
			AugAdd("aug_cc")
		elseif UsedObject == LuA_item_ks_up
			AugAdd("aug_ks")
		elseif UsedObject == LuA_item_gt_up
			AugAdd("aug_gt")
		elseif UsedObject == LuA_item_sb_up
			AugAdd("aug_sb")
		elseif UsedObject == LuA_item_rs_up
			AugAdd("aug_rs")
		elseif UsedObject == LuA_item_sbod_up
			AugAdd("aug_sbod")
		elseif UsedObject == LuA_item_tbod_up
			AugAdd("aug_tbod")
		elseif UsedObject == LuA_item_mbod_up
			AugAdd("aug_mbod")
		elseif UsedObject == LuA_item_removeaugs
			LuA_aug_sg_active.SetValue(0)
			LuA_aug_cc_active.SetValue(0)
			LuA_aug_ks_active.SetValue(0)
			LuA_aug_gt_active.SetValue(0)
			aug_ks_buildup = 0.0
			AugStrCalc(true)
		endIf
	elseif LuA_aug_gt_active.GetValue() >= 1.0
		if akBaseObject as Potion
			if akBaseObject.HasKeyword(ObjectTypeFood) || akBaseObject.HasKeyword(ObjectTypeWater) || akBaseObject.HasKeyword(ObjectTypeAlcohol) || akBaseObject.HasKeyword(ObjectTypeNukaCola)
				float AugStr = LuA_PC_StrAug.GetValue()
				if AugStr >= 1
					int x = Math.Floor(LuA_aug_gt_active.GetValue() * 30)
					PlayerRef.DamageValue(ActionPoints, x)
				else
					int x = Math.Floor((LuA_aug_gt_active.GetValue() * 30) * (1.0 + (1.0 - AugStr)))
					PlayerRef.DamageValue(ActionPoints, x)
				endIf
				
			endIf
		endIf
	endIf
	
; Keyword Property ObjectTypeFood auto
; Keyword Property ObjectTypeWater auto
; Keyword Property ObjectTypeAlcohol auto
; Keyword Property ObjectTypeNukaCola auto
endFunction
;end/

;ent/ Add Augment
Function AugAdd(string AugID="none")
	if AugID == "aug_sg" ; Sexual Growth
			float RealRank = LuA_aug_sg_active.GetValue()
			int CurRank = Math.Floor(RealRank)
			float IncRank = RealRank + ((1.0 - (1.0 / ((RealRank + 1.0) * 1.2))) * LuA_PC_StrAug.GetValue())
			bool IsInc = false
		if RealRank == 0.0
			CurRank += 1
			LuA_aug_sg_Active.SetValue(CurRank)
			IsInc = true
		elseif Math.Floor(IncRank) > CurRank
			CurRank += 1
			LuA_aug_sg_Active.SetValue(CurRank)
			IsInc = true
		else
			int chance = Math.Floor((IncRank - CurRank) * 100)
			int RandInt = Utility.RandomInt(0, 100)
			if RandInt <= chance
				CurRank += 1
				LuA_aug_sg_Active.SetValue(CurRank)
				IsInc = true
			else
				LuA_aug_sg_Active.SetValue(IncRank)
				IsInc = false
			endIf
		endIf
			;Notify Player of Result
		if  IsInc ;If full rank increase
			Debug.MessageBox("Enhanced Augment Rank \n \n Sexual Growth Rank "+CurRank+" \n\n Gain XP from Sexual Acts")
		else ;Failed By Chance
			Debug.MessageBox("Enhancement Failed!\n (Future Chance Increased) \n \n Sexual Growth Rank "+CurRank+" \n\n Gain XP from Sexual Acts")
		endIf
		AugStrCalc(true)
	elseIf AugID == "aug_cc" ; Cream Catch
		if LuA_aug_cc_active.GetValue() ; Failed Because Maxed
			Debug.MessageBox("Enhancement Failed!\n (Augment Already Maxed) \n \n Cream Catch (Maxed) \n\n Catch extra liquid from male partners.")
		else ; Added
			LuA_aug_cc_active.SetValue(1)
			Debug.MessageBox("Enhanced Augment Rank \n \n Cream Catch (Maxed) \n\n Catch extra liquid from male partners.")
		endIf
		AugStrCalc(true)
	elseif AugID == "aug_ks" ; Killing Spree
			float RealRank = LuA_aug_ks_active.GetValue()
			int CurRank = Math.Floor(RealRank)
			float IncRank = RealRank + ((1.0 - (1.0 / ((RealRank + 1.0) * 1.6))) * LuA_PC_StrAug.GetValue())
			bool IsInc = false
		if RealRank == 0.0
			CurRank += 1
			LuA_aug_ks_Active.SetValue(CurRank)
			IsInc = true
		elseif Math.Floor(IncRank) > CurRank
			CurRank += 1
			LuA_aug_ks_active.SetValue(CurRank)
			IsInc = true
		else
			int chance = Math.Floor((IncRank - CurRank) * 100)
			int RandInt = Utility.RandomInt(0, 100)
			if RandInt <= chance
				CurRank += 1
				LuA_aug_ks_active.SetValue(CurRank)
				IsInc = true
			else
				LuA_aug_ks_active.SetValue(IncRank)
				IsInc = false
			endIf
		endIf
			;Notify Player of Result
		if  IsInc ;If full rank increase
			Debug.MessageBox("Enhanced Augment Rank \n \n Killing Spree Rank "+CurRank+" \n\n Build-up bonus XP exponentially on kills. Claimed and Reset when Sleeping.")
		else ;Failed By Chance
			Debug.MessageBox("Enhancement Failed!\n (Future Chance Increased) \n \n Killing Spree Rank "+CurRank+" \n\n Build-up bonus XP exponentially on kills. Claimed and Reset when Sleeping.")
		endIf
		AugStrCalc(true)
	elseif AugID == "aug_gt" ; Gentle Tummy
		int CurRank = Math.Floor(LuA_aug_gt_active.GetValue())
		If (PlayerRef.GetBaseValue(ActionPoints) > (CurRank * 30))
			CurRank += 1
			LuA_aug_gt_active.SetValue(CurRank)
			Debug.MessageBox("Enhanced Augment Rank \n \n Gentle Tummy Rank "+CurRank+" \n\n Reduces AP when eating or drinking.")
		else
			Debug.MessageBox("Enhancement Failed!\n (Not Enough Max AP) \n \n Gentle Tummy Rank "+CurRank+" \n\n Reduces AP when eating or drinking.")
		endIf
		AugStrCalc(true)
	elseif AugID == "aug_sb" ; Strength Booster
			float RealRank = LuA_aug_sb_active.GetValue()
			int CurRank = Math.Floor(RealRank)
			float IncRank = RealRank + (1.0 - (1.0 / (RealRank + 1.0) * 1.2))
			bool IsInc = false
		if RealRank == 0.0
			CurRank += 1
			LuA_aug_sb_Active.SetValue(CurRank)
			IsInc = true
		elseif Math.Floor(IncRank + 0.01) > CurRank
			CurRank += 1
			LuA_aug_sb_active.SetValue(CurRank)
			IsInc = true
		else
			int chance = Math.Floor((IncRank - CurRank) * 100)
			int RandInt = Utility.RandomInt(0, 100)
			if RandInt <= chance
				CurRank += 1
				LuA_aug_sb_active.SetValue(CurRank)
				IsInc = true
			else
				LuA_aug_sb_active.SetValue(IncRank)
				IsInc = false
			endIf
		endIf
			;Notify Player of Result
		if  IsInc ;If full rank increase
			Debug.MessageBox("Enhanced Augment \n \n Strength Booster \n\n Slightly increases Augment Strength")
		else ;Failed By Chance
			Debug.MessageBox("Enhancement Failed!\n (Future Chance Increased) \n \n Strength Booster \n\n Slightly increases Augment Strength")
		endIf
		AugStrCalc(true)
	elseif AugID == "aug_rs" ; Rad Sleeper
			float RealRank = LuA_aug_rs_active.GetValue()
			int CurRank = Math.Floor(RealRank)
			float IncRank = RealRank + ((1.0 - (1.0 / ((RealRank + 1.0) * 1.4))) * LuA_PC_StrAug.GetValue())
			bool IsInc = false
		if RealRank == 0.0
			CurRank += 1
			LuA_aug_rs_Active.SetValue(CurRank)
			IsInc = true
		elseif Math.Floor(IncRank) > CurRank
			CurRank += 1
			LuA_aug_rs_active.SetValue(CurRank)
			IsInc = true
		else
			int chance = Math.Floor((IncRank - CurRank) * 100)
			int RandInt = Utility.RandomInt(0, 100)
			if RandInt <= chance
				CurRank += 1
				LuA_aug_rs_active.SetValue(CurRank)
				IsInc = true
			else
				LuA_aug_rs_active.SetValue(IncRank)
				IsInc = false
			endIf
		endIf
			;Notify Player of Result
		if  IsInc ;If full rank increase
			Debug.MessageBox("Enhanced Augment Rank \n \n Rad Sleeper Rank "+CurRank+" \n\n Decrease Radiation when sleeping uninterrupted.")
		else ;Failed By Chance
			Debug.MessageBox("Enhancement Failed!\n (Future Chance Increased) \n \n Rad Sleeper Rank "+CurRank+" \n\n Decrease Radiation when sleeping uninterrupted..")
		endIf
		AugStrCalc(true)
	elseif AugID == "aug_sbod" ; Slimer Body
		ActorBase:BodyWeight bodyWeight = PlayerRef.GetActorBase().GetBodyWeight()
		float thin = bodyWeight.Thin
		float muscle = bodyWeight.Muscular
		float thick = bodyWeight.Large
		if thin < 1.0
			float Newthin = thin + 0.2
			float Newmuscle = muscle - 0.1
			float Newthick = thick - 0.1
			float Difthin = 0.2
			float Difmuscle = 0.1
			float Difthick = 0.1
			if Newthin > 1.0
				Difthin = 1.0 - thin
			endIf
			if Newmuscle < 0.0
				Difmuscle = muscle
				Difthick += 0.1 - muscle
			endIf
			if Newthick < 0.0
				Difthick = thick
				Difmuscle += 0.1 - thick
			endIf
			Newthin = thin + Difthin
			Newmuscle = muscle - Difmuscle
			Newthick = thick - Difthick
			
			bodyWeight.Thin = Newthin
			bodyWeight.Muscular = Newmuscle
			bodyWeight.Large = Newthick
			 
			PlayerRef.GetActorBase().SetBodyWeight(bodyWeight)
			Game.GetPlayer().QueueUpdate(false, 0xC)
			
			Debug.MessageBox("Augment Succeeded \n\n "+thin+" Thin \n "+muscle+" Muscular \n "+thick+" Large")
		else
			Debug.MessageBox("Augment Failed \n (Slim Already Maxed) \n\n "+thin+" Thin \n "+muscle+" Muscular \n "+thick+" Large")
		endIf
	elseif AugID == "aug_mbod" ; Muscular Body
		ActorBase:BodyWeight bodyWeight = PlayerRef.GetActorBase().GetBodyWeight()
		float thin = bodyWeight.Thin
		float muscle = bodyWeight.Muscular
		float thick = bodyWeight.Large
		if muscle < 1.0
			float Newthin = thin - 0.1
			float Newmuscle = muscle + 0.2
			float Newthick = thick - 0.1
			float Difthin = 0.1
			float Difmuscle = 0.2
			float Difthick = 0.1
			if Newmuscle > 1.0
				Difmuscle = 1.0 - muscle
			endIf
			if Newthin < 0.0
				Difthin = thin
				Difthick += 0.1 - thin
			endIf
			if Newthick < 0.0
				Difthick = thick
				Difthin += 0.1 - thick
			endIf
			Newthin = thin + Difthin
			Newmuscle = muscle - Difmuscle
			Newthick = thick - Difthick
			
			bodyWeight.Thin = Newthin
			bodyWeight.Muscular = Newmuscle
			bodyWeight.Large = Newthick
			 
			PlayerRef.GetActorBase().SetBodyWeight(bodyWeight)
			Game.GetPlayer().QueueUpdate(false, 0xC)
			
			Debug.MessageBox("Augment Succeeded \n\n "+thin+" Thin \n "+muscle+" Muscular \n "+thick+" Large")
		else
			Debug.MessageBox("Augment Failed \n (Muscle Already Maxed) \n\n "+thin+" Thin \n "+muscle+" Muscular \n "+thick+" Large")
		endIf
	elseif AugID == "aug_sbod" ; Slimer Body
		ActorBase:BodyWeight bodyWeight = PlayerRef.GetActorBase().GetBodyWeight()
		float thin = bodyWeight.Thin
		float muscle = bodyWeight.Muscular
		float thick = bodyWeight.Large
		if thick < 1.0
			float Newthin = thin - 0.1
			float Newmuscle = muscle - 0.1
			float Newthick = thick + 0.2
			float Difthin = 0.1
			float Difmuscle = 0.1
			float Difthick = 0.2
			if Newthick > 1.0
				Difthick = 1.0 - thick
			endIf
			if Newmuscle < 0.0
				Difmuscle = muscle
				Difthin += 0.1 - muscle
			endIf
			if Newthin < 0.0
				Difthin = thin
				Difmuscle += 0.1 - thin
			endIf
			Newthin = thin + Difthin
			Newmuscle = muscle - Difmuscle
			Newthick = thick - Difthick
			
			bodyWeight.Thin = Newthin
			bodyWeight.Muscular = Newmuscle
			bodyWeight.Large = Newthick
			 
			PlayerRef.GetActorBase().SetBodyWeight(bodyWeight)
			Game.GetPlayer().QueueUpdate(false, 0xC)
			
			Debug.MessageBox("Augment Succeeded \n\n "+thin+" Thin \n "+muscle+" Muscular \n "+thick+" Large")
		else
			Debug.MessageBox("Augment Failed \n (Thick Already Maxed) \n\n "+thin+" Thin \n "+muscle+" Muscular \n "+thick+" Large")
		endIf
	endIf
endFunction
;end/

;ent/ Augment Strength Calc
Function AugStrCalc(bool displayMessage=false)
	; Starting Aug Stats
	int MaxAug = 1
	int CurAug = 0
	float StrAug = 0.0
	int gamediffset = Game.GetDifficulty()
	if gamediffset > 4
		MaxAug = 14
	elseif gamediffset == 3
		MaxAug = 12
	elseif gamediffset == 2
		MaxAug = 10
	else
		MaxAug = 8
	endIf
	
		; Modules
	float MaxUp
		; DOM
	if LuA_mod_da_active.GetValue()
		float da_rads = LuA_mod_da_rads.GetValue()
		float da_capsperc = LuA_mod_da_capsperc.GetValue()
		MaxUp += (da_rads * 0.1) + (da_capsperc * 0.05) ; 2 per 20% rads 2 per 40% caps
	endIf
		; Aug-
	MaxUp += LuA_aug_gt_active.GetValue() * 8
		;AugX
	MaxUp += Math.Floor(LuA_aug_sb_active.GetValue())
		; Set Int Increase
	MaxAug += Math.Floor(MaxUp)
	
	if MaxAug > (10 + (Game.GetPlayerLevel() * 2))
		MaxAug = Math.Floor(10 + (Game.GetPlayerLevel() * 2))
		AugCapped = true
	else
		AugCapped = false
	endIf
	
	; Aug+
	CurAug += Math.Floor(6 * LuA_aug_sg_active.GetValue() as int) ; Sexual Growth
	CurAug += Math.Floor(10 * LuA_aug_ks_active.GetValue() as int) ; Killing Spree
	CurAug += Math.Floor(15 * LuA_aug_rs_active.GetValue() as int) ; Rad Sleeper
	if LuA_aug_cc_active.GetValue() ; Cream Catch
		CurAug += 8
	endIf
	
	LuA_PC_MaxAug.SetValue(MaxAug)
	LuA_PC_CurAug.SetValue(CurAug)
	
	if CurAug == 0 ; If no augments active
		LuA_PC_StrAug.SetValue(1.2)
	else ; Calculate Strength Percentage
		float x = MaxAug
		float y = CurAug
		StrAug = x / y
		if StrAug > 1.200
			LuA_PC_StrAug.SetValue(1.2)
		else
			LuA_PC_StrAug.SetValue(StrAug)
		endIf
	endIf
	
	if displayMessage
		AugStrMsg()
	endIf
endFunction
;end/

;ent/ Augment Strength Message
Function AugStrMsg()
	int StrAugDis = Math.Floor(LuA_PC_StrAug.GetValue() * 100)
	string s = "" ; String to display
	int x = 0 ; Global Use
	int adultify = LuA_set_adultify.GetValue() as int
	
	s = s+"Augment Strength = "+StrAugDis+"%"
	
	if AugCapped == true
		s = s+" (capped)"
	endIf
	s = s+"\n Equipped Augments"
	if LuA_aug_cc_active.GetValue() && adultify == 1
		s = s+"\n Cream Catch (Maxed)"
	endIf
	x = LuA_aug_gt_active.GetValue() as int
	if x > 0
		s = s+"\n Gentle Tummy (Rank "+x+")"
	endIf
	x = LuA_aug_ks_active.GetValue() as int
	if x > 0
		s = s+"\n Killing Spree (Rank "+x+")"
	endIf
	x = LuA_aug_rs_active.GetValue() as int
	if x > 0
		s = s+"\n Rad Sleeper (Rank "+x+")"
	endIf
	x = LuA_aug_sg_active.GetValue() as int
	if x > 0  && adultify == 1
		s = s+"\n Sexual Growth (Rank "+x+")"
	endIf
	
	Debug.MessageBox(s)
endFunction
;end/

;ent/ Death Override Mode (DOM)
Function DeathOverride()
	DOMprocessing = 1
	DOMaaffailed = 0
	
		;Stop Combat and make baddies into friendsies
	PlayerRef.StopCombat()
	PlayerRef.StopCombatAlarm()
	int i = 0
	While i < CombatActors.Length
		CombatActors[i].AddToFaction(LuA_fac_tempally)
		CombatActors[i].StopCombat()
		CombatActors[i].StopCombatAlarm()
		i += 1
	endWhile
	ObjectReference[] PolledActors = PlayerRef.FindAllReferencesWithKeyword(ActorTypeNPC, 800.0)
	ObjectReference[] PolledActorsC = PlayerRef.FindAllReferencesWithKeyword(ActorTypeCreature, 800.0)
	i = 0
	While i < PolledActorsC.Length
		PolledActors.Add(PolledActorsC[i])
		i += 1
	endWhile
	i = 0
	While i < PolledActors.Length
		Actor PollActor = PolledActors[i] as Actor
		PollActor.AddToFaction(LuA_fac_tempally)
		PollActor.StopCombat()
		PollActor.StopCombatAlarm()
		i += 1
	EndWhile
		; Wait for player to not be bleeding out
	While PlayerRef.IsBleedingOut()
		Utility.Wait(0.1)
	endWhile
	
		;Modify Player Controls (to override Bleedout's layer and allow camera controls)
	InputEnableLayer LuA_InputLayer = InputEnableLayer.Create()
	LuA_InputLayer.DisablePlayerControls(true, true) ; disable movement and fighting
	LuA_InputLayer.EnablePlayerControls(false, false, true, true) ; enable camswitch and looking
	
		; try and disable power armor (probably won't work)
	if PlayerRef.IsInPowerArmor()
		PlayerRef.SwitchToPowerArmor(None)
	endIf
	
	if LuA_set_adultify.GetValue() && AAFfound == 1
		if LuA_mod_da_trytoanim.GetValue()
		; Start AAF Animation
			Actor ActAgg = LastHitActor
			i = 0
			bool exit = false
			if ActAgg == none
				bool trypoll = false
				While exit != true
					if CombatActors[i].IsDead() || CombatActors[i].GetLeveledActorBase().GetSex() == 1
						i += 1
						if i > CombatActors.Length
							exit = true
						endIf
					else
						ActAgg = CombatActors[i]
						trypoll = false
						exit = true
					endIf
				endWhile
				if trypoll == true
					i = 0
					While exit != true
						Actor PollActor = PolledActors[i] as Actor
						if PollActor.IsDead() || PollActor.GetLeveledActorBase().GetSex() == 1
							i += 1
							if i > PolledActors.Length
								exit = true
							endIf
						else
							ActAgg = PollActor
							exit = true
						endIf
					endWhile
				endIf
			endIf
			if ActAgg == none || PlayerRef.HasKeyword(AAF_API.AAF_ActorBusy)
				DOMaaffailed = 1
			else
				Actor[] AnimActors = new Actor[2]
				AnimActors[0] = PlayerRef
				AnimActors[1] = ActAgg
				AAF:AAF_API:SceneSettings settings = AAF_API.GetSceneSettings()
				settings.duration = LuA_set_animlength.GetValue() as int
				settings.preventFurniture = true
				settings.usePackages = false
				settings.position = None
				settings.excludeTags = None
				settings.locationObject = PlayerRef
				AAF_API.StartScene(AnimActors, settings)
			endIf
		endIf
		if LuA_mod_da_trytoanim.GetValue() || LuA_mod_da_waitforanim.GetValue()
			int timeout = 0
			While DOMaaffailed == 0 ; Wait for AAF to report
				if timeout > 300 ; Waits half a minute...
					DOMaaffailed = 1
					Debug.MessageBox("DOM WaitForAnim Timed Out - No AAF response")
				else
					timeout += 1
					Utility.Wait(0.1)
				endIf
			endWhile
			
			if DOMaaffailed == 3 ; If animation validated
				int foundkey = 0
				While foundkey == 0 ; Wait for player to have keyword
					if PlayerRef.HasKeyword(AAF_API.AAF_ActorBusy)
						foundkey = 1
					else
						Utility.Wait(0.1)
					endIf
				endWhile
				While PlayerRef.HasKeyword(AAF_API.AAF_ActorBusy) ;Wait for keyword to be removed before proceeding
					Utility.Wait(0.1)
				endWhile
				Utility.Wait(0.2) ; Give time to process ending
			endIf
		endIf
	endIf
	
	PlayerRef.MoveTo(LuA_Marker_LimboEntry)
	WasBleedingOut = 0
	
	;Remove Caps
	int CapsCount = PlayerRef.GetItemCount(Caps001)
	;int InvWeight = PlayerRef.GetInventoryWeight() as int
	; int capsremcount = Math.Floor((CapsCount * 0.01) + ((InvWeight * 0.3) + InvWeight))
	int capsremperc = LuA_mod_da_capsperc.GetValue() as int
	if capsremperc > 0
		int capsremcount = Math.Floor(CapsCount * (capsremperc * 0.01))
		if capsremcount >= 1
			if capsremcount > CapsCount
				PlayerRef.RemoveItem(Caps001, capsremcount)
				;debug.Notification(CapsCount+" caps lost")
			else
				PlayerRef.RemoveItem(Caps001, capsremcount)
				;debug.Notification(capsremcount+" caps lost")
			endIf
		endIf
	endIf
	; Cause Rads Damage
	float radsdam = (LuA_mod_da_rads.GetValue() * 10)
	if radsdam > 0
		float radsplayer = PlayerRef.GetValue(Rads)
		float radsnew = radsplayer + radsdam
		if radsplayer > 800
			PlayerRef.RestoreValue(Rads, radsplayer - 800)
		elseif radsnew < 800
			PlayerRef.DamageValue(Rads, radsdam)
		elseif radsnew > 800
			PlayerRef.DamageValue(Rads, 800 - radsplayer)
		endIf
	endIf
	; Reset Killing Spree
	if LuA_aug_ks_active.GetValue() >= 1.0
		int x = Math.Floor(aug_ks_buildup)
		aug_ks_buildup = 0
		debug.Notification("Killing Spree Build-up Lost : "+x)
	endIf
	; Restore health to max
	PlayerRef.RestoreValue(Health, 99999999) ;(if they're higher than this they cheatin' anyways)
	; Make Baddies into Baddies again
	i = 0
	While i < CombatActors.Length
		Actor PollActor = PolledActors[i] as Actor
		PollActor.RemoveFromFaction(LuA_fac_tempally)
		;CombatActors[i].RemoveFromFaction(LuA_fac_tempally)
		i += 1
	endWhile
	; Re-Enabled Player Controls
	LuA_InputLayer.Delete()
	DOMprocessing = 0
	DOMaaffailed = 0
endFunction

Function DOMReturn()
	if RespawnPoint == 0 || LuA_mod_da_mustrestreturn.GetValue()
		PlayerRef.MoveTo(LuA_Marker_RestEntry)
	else
		PlayerRef.MoveTo(LuA_Marker_LastEntry)
		Debug.SetGodMode(true)
		InputEnableLayer LuA_InputLayer = InputEnableLayer.Create()
		LuA_InputLayer.DisablePlayerControls(false, true) ; disable fighting
		LuA_InputLayer.EnablePlayerControls(false, false, true, true) ; enable camswitch and looking
		Utility.Wait(5.0)
		Debug.SetGodMode(false)
		LuA_InputLayer.Delete()
	endIf
endFunction
;end/

;ent/ MCM Registers
Function OnMCMOpen() ; Triggers when MCM is opened
    MCM.RefreshMenu()
EndFunction

Function OnMCMSettingChange(string modName, string id)
    If modName == "LucrativeAugments"
        If id == "DOMenable" ;what id changed
			if LuA_mod_da_active.GetValue()
				PlayerRef.SetEssential(True)
			else
				PlayerRef.SetEssential(False)
			endIf
		elseif id == "DOMradsperc" || id == "DOMcapsperc"
			AugStrCalc(false)
        EndIf
    EndIf
EndFunction
;end/

;ent/ AAF Registers
Event AAF:AAF_API.OnSceneInit(AAF:AAF_API akSender, Var[] akArgs)
	int Invalidate = akArgs[0] as int ; Check animation 'status'
	if Invalidate == 0 ; Didn't Invalidate with an error
		
		Actor[] AnimActors = Utility.VarToVarArray(akArgs[1]) as Actor[]
		int i = 0
		While i < AnimActors.Length
			if AnimActors[i] == PlayerRef
				DOMaaffailed = 3
				Actor doppelganger = akArgs[2] as Actor
				doppelganger.AddToFaction(LuA_fac_tempally)
				doppelganger.StopCombat()
				doppelganger.StopCombatAlarm()
			endIf
			i += 1
		endWhile
	else
		if ActorSeduced == True
			Actor[] AnimActors = Utility.VarToVarArray(akArgs[2]) as Actor[]
			int i = 0
			While i < AnimActors.Length
				if AnimActors[i] == PlayerRef
					SeductionCooldown = 0
					ActorSeduced = false
					debug.MessageBox("Seduction Error : AAF Failed to Initiate Anim")
				endIf
				i += 1
			endWhile
		endIf
		if DOMprocessing == 1 ; is invalid and DOM running
			Actor[] AnimActors = Utility.VarToVarArray(akArgs[2]) as Actor[]
			int i = 0
			While i < AnimActors.Length
				if AnimActors[i] == PlayerRef
					DOMaaffailed = 1
				endIf
				i += 1
			endWhile
		endIf
	endIf
EndEvent

Event AAF:AAF_API.OnAnimationStart(AAF:AAF_API akSender, Var[] akArgs)
EndEvent

Event AAF:AAF_API.OnAnimationChange(AAF:AAF_API akSender, Var[] akArgs)
EndEvent

Event AAF:AAF_API.OnAnimationStop(AAF:AAF_API akSender, Var[] akArgs)
	int Invalidate = akArgs[0] as int ; Check animation 'status'
	if Invalidate == 0 ; Didn't Invalidate with an error
		Actor[] AnimActors = Utility.VarToVarArray(akArgs[1]) as Actor[]
		int malecount = 0 ; 0 = male
		int femalecount = 0 ; 1 = female
		int IsPlayerActive = 0 ; Is Player Involved?
		int i = 0
		while i < AnimActors.Length
			int ActorGender = AnimActors[i].GetLeveledActorBase().GetSex()
			
			if AnimActors[i] == PlayerRef
				femalecount += 1
			elseif ActorGender == 0
				malecount += 1
			elseif ActorGender == 1
				femalecount += 1
			endIf
			
			if AnimActors[i] == PlayerRef
				IsPlayerActive = 1
			endIf
			i += 1
		endWhile
		
		if IsPlayerActive == 1 && malecount != 0
			if LuA_aug_cc_active.GetValue()
				PlayerRef.AddItem(LuA_item_sperm, (1 * malecount), True) ; Cream Catch
			endIf
			int aug_sg = LuA_aug_sg_active.GetValue() as int
			if aug_sg > 0 ; Sexual Growth
				Game.RewardPlayerXP(Math.Floor((10 + (Game.GetPlayerLevel() * 0.2)) * aug_sg * LuA_PC_StrAug.GetValue()))
				PlayerInAAF == 0
				ActorSeduced = false
			endIf
		endIf
	endIf
EndEvent
;end/